;----------------------------------------------------------------------------
; PC Games
; PCLAUNCHER.exe
; by djvj
; 1.0
;
; Notes:
; This script benefits those with large PC or similar games collections that want it to be more portable. If you ever change a dir name or structure and you are using LNKor BAT files, you have to recreate EVERY LNK/BAT file.
; With all dir locations being in one ini, you can do a find/replace to make mass changes to dir names. Very helpful if you want to move games off to another HD and the thought of remaking hundreds of LNK/BAT files seems daunting.
;
; Make a file called PCLAUNCHER.ahk (or whatever you want to call it), right click and compile it. Set this as your emu exe.
; Make a folder called txt in your emu folder. Create a blank txt file named the same as each game name from your database xml.
; You rompath is your txt folder.
; Create a settings.ini and place it with this module. This is an example of what each game should look like in the settings.ini. The name in brackets should match your game name.
;
; [Street Fighter IV]
; gamePath = C:\Program Files (x86)\CAPCOM\STREETFIGHTERIV\sfiv.exe
; params = 
; [Super Mario War]
; gamePath = C:\HyperSpin\Emulators\PC Games\smw-1.8-beta2-bin\SuperMarioWar.exe
; params = 
;
; params are anything that you need to pass to the game in CLI. Leave blank if you are unsure.
; Use the PC game's native exit routine to get back to HS.
;----------------------------------------------------------------------------

IniRead, gamePath, %A_Scriptdir%\Modules\%systemName%\settings.ini, %romName%, gamePath
IniRead, params, %A_Scriptdir%\Modules\%systemName%\settings.ini, %romName%, params

RunWait, %romPath%%romName%%romExtension% %params%
WinActivate, HyperSpin

ExitApp

CloseProcess:
return